#!/usr/bin/python2
# -*- coding: utf-8 -*-

__author__ = 'Patryk Stachurski <patryk.stachurski@open-e.com>'
__revision__ = '$Id'

from jovianapi.resource.core import Resource
from jovianapi.resource.core import ResourcesContainer
from jovianapi.resource.core import UNDEFINED


class ZfsResourceModel(Resource):
    FIELDS_NAMES = ['status', 'node_id', 'name']

    def __init__(self, status=UNDEFINED, node_id=UNDEFINED, name=UNDEFINED, api=None):
        """
        :type status: unicode
        :type node_id: unicode
        :type name: unicode
        :type api: jovianapi.API
        """
        Resource.__init__(self, api=api)

        self.status = status
        self.node_id = node_id
        self.name = name


class ZfsResource(ZfsResourceModel):
    pass


class ZfsResourcesContainer(ResourcesContainer):
    def fetch(self):
        items = self.driver.list_cluster_zfs_resources().data
        return [ZfsResource.from_dict(i, api=self.api) for i in items]

    # just for code hint
    def __getitem__(self, key):
        """
        :rtype: ZfsResource
        """
        return ResourcesContainer.__getitem__(self, key)
