#!/usr/bin/python2
# -*- coding: utf-8 -*-

__author__ = 'Patryk Stachurski <patryk.stachurski@open-e.com>'
__revision__ = '$Id'


class Error(dict):
    def __init__(self, raw):
        self.raw = raw

        dict.__init__(self, raw or {})

    @property
    def message(self):
        return self.get('message')

    @property
    def cls_name(self):
        return self.get('class')


class Response(dict):
    def __init__(self, raw, code):
        self.raw = raw
        self.code = code

        dict.__init__(self, raw)

    @property
    def data(self):
        return self.get('data', dict())

    @property
    def error(self):
        return Error(self.get('error', dict()))
