#!/usr/bin/python2
# -*- coding: utf-8 -*-

__author__ = 'Patryk Stachurski <patryk.stachurski@open-e.com>'
__revision__ = '$Id'

from jovianapi.resource.core import Resource
from jovianapi.resource.core import ResourcesContainer
from jovianapi.resource.core import UNDEFINED


class VolumeModel(Resource):
    FIELDS_NAMES = ['origin', 'referenced', 'primarycache', 'logbias', 'creation', 'sync', 'is_clone', 'dedup', 'used',
                    'full_name', 'usedbysnapshots', 'readonly', 'compression', 'copies', 'compressratio', 'written',
                    'mlslabel', 'secondarycache', 'available', 'resource_name', 'volblocksize', 'refcompressratio',
                    'snapdev', 'volsize', 'reservation', 'usedbyrefreservation', 'usedbychildren', 'usedbydataset',
                    'name', 'type', 'refreservation', 'checksum']

    def __init__(self, origin=UNDEFINED, referenced=UNDEFINED, primarycache=UNDEFINED, logbias=UNDEFINED,
                 creation=UNDEFINED, sync=UNDEFINED, is_clone=UNDEFINED, dedup=UNDEFINED, used=UNDEFINED,
                 full_name=UNDEFINED, usedbysnapshots=UNDEFINED, readonly=UNDEFINED, compression=UNDEFINED,
                 copies=UNDEFINED, compressratio=UNDEFINED, written=UNDEFINED, mlslabel=UNDEFINED,
                 secondarycache=UNDEFINED, available=UNDEFINED, resource_name=UNDEFINED, volblocksize=UNDEFINED,
                 refcompressratio=UNDEFINED, snapdev=UNDEFINED, volsize=UNDEFINED, reservation=UNDEFINED,
                 usedbyrefreservation=UNDEFINED, usedbychildren=UNDEFINED, usedbydataset=UNDEFINED, name=UNDEFINED,
                 type=UNDEFINED, refreservation=UNDEFINED, checksum=UNDEFINED, pool=None, api=None):  # pylint: disable=redefined-builtin
        """
        :type origin: NoneType
        :type referenced: unicode
        :type primarycache: unicode
        :type logbias: unicode
        :type creation: unicode
        :type sync: unicode
        :type is_clone: bool
        :type dedup: unicode
        :type used: unicode
        :type full_name: unicode
        :type usedbysnapshots: unicode
        :type readonly: unicode
        :type compression: unicode
        :type copies: unicode
        :type compressratio: unicode
        :type written: unicode
        :type mlslabel: unicode
        :type secondarycache: unicode
        :type available: unicode
        :type resource_name: unicode
        :type volblocksize: unicode
        :type refcompressratio: unicode
        :type snapdev: unicode
        :type volsize: unicode
        :type reservation: unicode
        :type usedbyrefreservation: unicode
        :type usedbychildren: unicode
        :type usedbydataset: unicode
        :type name: unicode
        :type type: unicode
        :type refreservation: unicode
        :type checksum: unicode
        :type pool: jovianapi.resource.pool.Pool
        :type api: jovianapi.API
        """
        Resource.__init__(self, api=api)

        self.origin = origin
        self.referenced = referenced
        self.primarycache = primarycache
        self.logbias = logbias
        self.creation = creation
        self.sync = sync
        self.is_clone = is_clone
        self.dedup = dedup
        self.used = used
        self.full_name = full_name
        self.usedbysnapshots = usedbysnapshots
        self.readonly = readonly
        self.compression = compression
        self.copies = copies
        self.compressratio = compressratio
        self.written = written
        self.mlslabel = mlslabel
        self.secondarycache = secondarycache
        self.available = available
        self.resource_name = resource_name
        self.volblocksize = volblocksize
        self.refcompressratio = refcompressratio
        self.snapdev = snapdev
        self.volsize = volsize
        self.reservation = reservation
        self.usedbyrefreservation = usedbyrefreservation
        self.usedbychildren = usedbychildren
        self.usedbydataset = usedbydataset
        self.name = name
        self.type = type
        self.refreservation = refreservation
        self.checksum = checksum

        self.pool = pool


class Volume(VolumeModel):
    pass


class VolumesContainer(ResourcesContainer):
    def __init__(self, pool):
        """
        :type pool: jovianapi.resource.pool.Pool
        """
        self.pool = pool

        super(VolumesContainer, self).__init__(pool.api)

    def fetch(self):
        items = self.driver.list_volumes(self.pool.name).data
        return [Volume.from_dict(d, api=self.api, pool=self.pool) for d in items]

    def create(self, name, size):
        """
        :rtype: VolumeModel
        """
        volume_model = VolumeModel(name=name)

        volume_data = volume_model.to_dict()
        # FIXME: POST requires 'size' and GET returns 'volsize'
        volume_data['size'] = str(size)

        self.api.driver.create_volume(self.pool.name, volume_data)
        self.refresh()
        for vol in self:
            if vol.name == name:
                return vol

