#!/usr/bin/python2
# -*- coding: utf-8 -*-

__author__ = 'Patryk Stachurski <patryk.stachurski@open-e.com>'
__revision__ = '$Id'

from jovianapi.driver.rest import DriverREST

from jovianapi.menu.storage import StorageMenu
from jovianapi.menu.system import SystemMenu
from jovianapi.menu.cluster import ClusterMenu


class API(object):
    """This class represents interface of certain node.

    Resources are grouped into menus (it's next thing which you should recognize):
     - Storage (:class:`jovianapi.menu.storage.StorageMenu`)

    If you are going to operate on a menu for a bit longer, it's a good idea to make a shortcut::

        >>> storage = api.storage
    """

    @classmethod
    def via_rest(cls, address='127.0.0.1', port=81, username='', password=''):
        """Creates interface to certain node using REST driver.

        :param address: Address of machine.
        :param port: Port on which REST is served.
        :param username: Username of REST user.
        :param password: Password of REST user.
        :type address: str
        :type port: int
        :type username: str
        :type password: str

        Example of usage::

            >>> api = API.via_rest(address='192.168.176.61', port=81, username='admin', password='admin')
        """
        driver = DriverREST(address, port, username, password)
        return cls(driver)

    def __init__(self, driver):
        """
        :type driver: jovianapi.driver.rest.DriverREST
        """
        self.driver = driver

        self.storage = StorageMenu(self)
        self.system = SystemMenu(self)
        self.cluster = ClusterMenu(self)

