from time import sleep

from jovianapi.resource.core import Resource
from jovianapi.resource.core import ResourcesContainer
from jovianapi.resource.core import UNDEFINED


class PoolModel(Resource):
    class IostatsModel(Resource):
        FIELDS_NAMES = ['read', 'write', 'chksum']

        def __init__(self, read=UNDEFINED, write=UNDEFINED, chksum=UNDEFINED, api=None):
            """
            :type read: unicode
            :type write: unicode
            :type chksum: unicode
            :type api: jovianapi.API
            """
            Resource.__init__(self, api=api)

            self.read = read
            self.write = write
            self.chksum = chksum

    class VdevModel(Resource):
        class DiskModel(Resource):
            FIELDS_NAMES = ['led', 'name', 'iostats', 'health', 'sn', 'path', 'origin', 'model', 'id', 'size']

            def __init__(self, led=UNDEFINED, name=UNDEFINED, iostats=UNDEFINED, health=UNDEFINED, sn=UNDEFINED,
                         path=UNDEFINED, origin=UNDEFINED, model=UNDEFINED, id=UNDEFINED, size=UNDEFINED, api=None):  # pylint: disable=redefined-builtin
                """
                :type led: unicode
                :type name: unicode
                :type iostats: PoolModel.IostatsModel
                :type health: unicode
                :type sn: unicode
                :type path: NoneType
                :type origin: unicode
                :type model: unicode
                :type id: unicode
                :type size: int
                :type api: jovianapi.API
                """
                Resource.__init__(self, api=api)

                self.led = led
                self.name = name
                self.iostats = PoolModel.IostatsModel.from_dict(iostats)
                self.health = health
                self.sn = sn
                self.path = path
                self.origin = origin
                self.model = model
                self.id = id
                self.size = size

        FIELDS_NAMES = ['name', 'iostats', 'disks', 'health', 'vdev_replacings', 'vdev_spares', 'type']

        TYPE_SINGLE = ''

        def __init__(self, name=UNDEFINED, iostats=UNDEFINED, disks=UNDEFINED, health=UNDEFINED,
                     vdev_replacings=UNDEFINED, vdev_spares=UNDEFINED, type=UNDEFINED, api=None):  # pylint: disable=redefined-builtin
            """
            :type name: unicode
            :type iostats: PoolModel.IostatsModel
            :type disks: list[PoolModel.VdevModel.DiskModel]
            :type health: unicode
            :type vdev_replacings: list
            :type vdev_spares: list
            :type type: unicode
            :type api: jovianapi.API
            """
            Resource.__init__(self, api=api)

            self.name = name
            self.iostats = PoolModel.IostatsModel.from_dict(iostats)
            self.disks = [PoolModel.VdevModel.DiskModel.from_dict(disk_data) for disk_data in disks]
            self.health = health
            self.vdev_replacings = vdev_replacings
            self.vdev_spares = vdev_spares
            self.type = type

    FIELDS_NAMES = ['available', 'status', 'name', 'scan', 'iostats', 'vdevs', 'health', 'operation', 'id', 'size']

    def __init__(self, available=UNDEFINED, status=UNDEFINED, name=UNDEFINED, scan=UNDEFINED, iostats=UNDEFINED,
                 vdevs=UNDEFINED, health=UNDEFINED, operation=UNDEFINED, id=UNDEFINED, size=UNDEFINED, api=None):  # pylint: disable=redefined-builtin
        """
        :type available: unicode
        :type status: int
        :type name: unicode
        :type scan: NoneType
        :type iostats: IostatsModel
        :type vdevs: list[PoolModel.VdevModel]
        :type health: unicode
        :type operation: unicode
        :type id: unicode
        :type size: unicode
        :type api: jovianapi.API
        """
        Resource.__init__(self, api=api)

        self.available = available
        self.status = status
        self.name = name
        self.scan = scan
        self.iostats = self.IostatsModel.from_dict(iostats)
        self.vdevs = [self.VdevModel.from_dict(vdev_data) for vdev_data in vdevs] \
            if vdevs is not UNDEFINED else UNDEFINED
        self.health = health
        self.operation = operation
        self.id = id
        self.size = size


class Pool(PoolModel):
    # There is conflict with Python reserved keyword "import"
    def import_(self, new_name=None):
        if new_name is None:
            new_name = self.name

        data = dict(id=self.id, name=new_name)
        self.driver.import_pool(data)
        return self

    def export(self):
        data = dict(name=self.name)
        self.driver.export_pool(data)
        return self

    def move(self, node):
        """
        :param node: Node ID or instance of NodeModel
        """
        from jovianapi.resource.node import NodeModel

        if isinstance(node, NodeModel):
            node = node.id

        data = dict(node_id=node)

        self.driver.move_cluster_resource(self.name, data)

    @property
    def datasets(self):
        """
        :rtype: jovianapi.resource.dataset.DatasetsContainer
        """
        from jovianapi.resource.dataset import DatasetsContainer
        return DatasetsContainer(self)

    @property
    def targets(self):
        from jovianapi.resource.target import TargetsContainer
        return TargetsContainer(self)

    @property
    def volumes(self):
        from jovianapi.resource.volume import VolumesContainer
        return VolumesContainer(self)


class PoolsContainer(ResourcesContainer):
    ITEM_MODEL = Pool

    def fetch(self):
        items = self.driver.list_pools().data
        return [self.ITEM_MODEL.from_dict(i, api=self.api) for i in items]

    def create(self, name, vdevs):
        data = dict(name=name, vdevs=[])

        for vdev in vdevs:
            vdev_data = dict(type=vdev.type, disks=[d.id for d in vdev.disks])
            data['vdevs'].append(vdev_data)

        self.driver.create_pool(data)

        for _ in range(30):
            try:
                return self[name]
            except KeyError:
                sleep(2)

    @property
    def exported(self):
        items = self.driver.list_pools_exported().data
        return [self.ITEM_MODEL.from_dict(i, api=self.api) for i in items]

    # just for code hint
    def __getitem__(self, name):
        """
        :rtype: Pool
        """
        return super(PoolsContainer, self).__getitem__(name)
