from jovianapi import API


###################
# Prepare interface
# Node info
IP = '192.168.251.182'
PORT = 82
USER = 'admin'
PASSWORD = 'admin'

# Init API
api = API.via_rest(IP, PORT, USER, PASSWORD)

#################
# Data for script
# Task info
POOL_NAME = 'Pool-0'        # Existing
DATASET_NAME = 'Dataset-0'  # Existing
SNAP_NAME = 'Dataset-Snap'  # To be created
CLONE_NAME = 'Snap-Clone'   # To be created
SHARE_NAME = 'Clone-Share'  # To be created


#############
# Script flow


# Create snapshot
endpoint = '/pools/{POOL_NAME}/nas-volumes/{DATASET_NAME}/snapshots'.format(
        POOL_NAME=POOL_NAME, DATASET_NAME=DATASET_NAME)
data = dict(name=SNAP_NAME)

api.driver.post(endpoint, data)

# Create clone
endpoint = '/pools/{POOL_NAME}/nas-volumes/{DATASET_NAME}/snapshots/{SNAP_NAME}/clones'.format(
    POOL_NAME=POOL_NAME, DATASET_NAME=DATASET_NAME, SNAP_NAME=SNAP_NAME)
data = dict(name=CLONE_NAME)

api.driver.post(endpoint, data)

# Create share
endpoint = '/shares'
data = dict(name=SHARE_NAME,
            path='{POOL_NAME}/{CLONE_NAME}'.format(POOL_NAME=POOL_NAME, CLONE_NAME=CLONE_NAME),
            nfs=dict(enabled=True),
            )

api.driver.post(endpoint, data)
