from jovianapi import API
from jovianapi.resource.vdev import Vdev


###################
# Prepare interface
# Node info
IP = '192.168.251.225'
PORT = 82
USER = 'admin'
PASSWORD = 'admin'

# Init API
api = API.via_rest(IP, PORT, USER, PASSWORD)


#################
# Data for script
# Task info
DATASETS_PER_POOL = 10
SHARES_PER_DATASET = 100


#############
# Script flow
avail_disks = [api.storage.disks.unused.pop()]

for pool_no, disk in enumerate(avail_disks):
    print '='*10
    pool_name = 'TestPool-%d' % pool_no

    print 'Creating pool: %s' % pool_name
    pool = api.storage.pools.create(name=pool_name,
                                    vdevs=[Vdev(type=Vdev.SINGLE, disks=[disk])])

    for dataset_no in range(DATASETS_PER_POOL):
        dataset_name = 'p%dd%d' % (pool_no, dataset_no)

        print 'Creating dataset: %s' % dataset_name
        dataset = pool.datasets.create(dataset_name)

        for share_no in range(SHARES_PER_DATASET):
            share_name = dataset_name + 's%d' % share_no

            print 'Creating share: %s' % share_name
            dataset.shares.create(share_name, smb_options=dict(enabled=True))
