from jovianapi import API
from jovianapi.resource.vdev import Vdev

from concurrent.futures import ThreadPoolExecutor


###################
# Prepare interface
# Node info
IP = '192.168.251.41'
PORT = 82
USER = 'admin'
PASSWORD = 'admin'

#################
# Data for script
# Task info
SMB_POOL_NAME = 'Pool-SMB'
SMB_DATASET_NAME = 'Dataset-SMB'
SMB_SHARE_PATTERN = 'SMB-Share-%d'
SMB_SHARES_COUNT = 1000
SMB_SHARES_CREATED_PARALLEL = 50

NFS_POOL_NAME = 'Pool-NFS'
NFS_DATASET_NAME = 'Dataset-NFS'
NFS_SHARE_PATTERN = 'NFS-Share-%d'
NFS_SHARES_COUNT = 1000
NFS_SHARES_CREATED_PARALLEL = 50


# Init API
api = API.via_rest(IP, PORT, USER, PASSWORD)


#############
# Script flow
smb_disk, nfs_disk = api.storage.disks.unused[:2]  # First two unused disks

smb_vdevs = [Vdev(type=Vdev.SINGLE, disks=[smb_disk])]
nfs_vdevs = [Vdev(type=Vdev.SINGLE, disks=[nfs_disk])]

# SMB
smb_pool = api.storage.pools.create(SMB_POOL_NAME, smb_vdevs)
smb_dataset = smb_pool.datasets.create(SMB_DATASET_NAME)
smb_shares = smb_dataset.shares

with ThreadPoolExecutor(max_workers=SMB_SHARES_CREATED_PARALLEL) as smb_executor:
    for x in xrange(SMB_SHARES_COUNT):
        smb_name = SMB_SHARE_PATTERN % x

        smb_executor.submit(smb_shares.create, smb_name, smb_options=dict(enabled=True))


# NFS
nfs_pool = api.storage.pools.create(NFS_POOL_NAME, nfs_vdevs)
nfs_dataset = nfs_pool.datasets.create(NFS_DATASET_NAME)
nfs_shares = nfs_dataset.shares

with ThreadPoolExecutor(max_workers=NFS_SHARES_CREATED_PARALLEL) as nfs_executor:
    for y in xrange(NFS_SHARES_COUNT):
        nfs_name = NFS_SHARE_PATTERN % y

        nfs_executor.submit(nfs_shares.create, nfs_name, nfs_options=dict(enabled=True))

