from jovianapi.resource.core import Resource
from jovianapi.resource.core import ResourcesContainer


class NICContainer(ResourcesContainer):
    def fetch(self):
        items = self.driver.list_nics().data
        return [NIC(i) for i in items]

    @property
    def used(self):
        """
        :rtype: list[Disk]
        """
        items = self.driver.list_disks_used().data
        return [NIC(i) for i in items]

    @property
    def unused(self):
        """
        :rtype: list[Disk]
        """
        items = self.driver.list_disks_unused().data
        return [NIC(i) for i in items]


class NIC(Resource):
    @property
    def status(self):
        """
        @rtype: unicode
        """
        return self["status"]

    @property
    def negotiated_speed(self):
        """
        @rtype: int
        """
        return self["negotiated_speed"]

    @property
    def name(self):
        """
        @rtype: unicode
        """
        return self["name"]

    @property
    def duplex(self):
        """
        @rtype: unicode
        """
        return self["duplex"]

    @property
    def speed(self):
        """
        @rtype: int
        """
        return self["speed"]

    @property
    def mac_address(self):
        """
        @rtype: unicode
        """
        return self["mac_address"]

    @property
    def operational_state(self):
        """
        @rtype: unicode
        """
        return self["operational_state"]

    @property
    def broadcast(self):
        """
        @rtype: NoneType
        """
        return self["broadcast"]

    @property
    def netmask(self):
        """
        @rtype: unicode
        """
        return self["netmask"]

    @property
    def carrier(self):
        """
        @rtype: bool
        """
        return self["carrier"]

    @property
    def is_up(self):
        """
        @rtype: bool
        """
        return self["is_up"]

    @property
    def address(self):
        """
        @rtype: unicode
        """
        return self["address"]

    @property
    def model(self):
        """
        @rtype: unicode
        """
        return self["model"]

    @property
    def configuration(self):
        """
        @rtype: unicode
        """
        return self["configuration"]

    @property
    def type(self):
        """
        @rtype: unicode
        """
        return self["type"]

    @property
    def gateway(self):
        """
        @rtype: NoneType
        """
        return self["gateway"]