from jovianapi import API
from jovianapi.driver.rest import DriverException

from time import sleep


node_a = API.via_rest('192.168.191.128', 82, 'admin', 'admin')
node_b = API.via_rest('192.168.191.131', 82, 'admin', 'admin')


while True:
    try:
        for node in [node_a, node_b]:
            remote_node = None
            # Search remote node
            for cluster_node in node.cluster.nodes:
                if not cluster_node.localnode:
                    remote_node = cluster_node
                    break

            # If there are any errors on storage raise error
            for pool in node.storage.pools:
                for vdev in pool.vdevs:
                    for disk in vdev.disks:
                        if disk.health != 'ONLINE':
                            raise RuntimeError('BUG OCCURRED !!!')

                # status 24 is 'ONLINE'
                # wait until pool starts and move it to another node then
                rsc_status = node.cluster.zfs_resources[pool.name].status
                if pool.status == 24 and pool.operation == 'none' and rsc_status == 'started':
                    print 'Moving %s to %s' % (pool.name, remote_node.address)
                    pool.move(remote_node)

            sleep(1)

    except DriverException as exc:
        print
        print 'ERROR:'
        print str(exc)
        print
