#!/usr/bin/python2
# -*- coding: utf-8 -*-

__author__ = 'Patryk Stachurski <patryk.stachurski@open-e.com>'
__revision__ = '$Id'

from abc import ABCMeta, abstractmethod


class AbstractDriver(object):
    __metaclass__ = ABCMeta

    @abstractmethod
    def list_disks(self):
        """
        List all disks.

        Example output::

            [
                {
                    u'assignment': u'active_pool_disk',
                    u'id': u'scsi-SATA_WDC_WD1001FALS-0_WD-WCATR0257285',
                    u'led': u'off',
                    u'model': u'WDC WD1001FALS0',
                    u'name': u'sdb',
                    u'path': None,
                    u'pool_name': u'Pool-0',
                    u'size': 1000204886016,
                    u'sn': u'WDWCATR0257285',
                    u'spare': [],
                    u'type': u'single',
                    u'used': True
                },
                {
                    u'assignment': u'system_disk',
                    u'id': u'scsi-SATA_ST3500630NS_9QG8WWA3',
                    u'led': u'off',
                    u'model': u'ST3500630NS     ',
                    u'name': u'sda',
                    u'path': None,
                    u'pool_name': None,
                    u'size': 500107862016,
                    u'sn': u'9QG8WWA3',
                    u'spare': [],
                    u'type': u'single',
                    u'used': True
                }
            ]

        :rtype: list[dict]
        """

    @abstractmethod
    def list_disks_used(self):
        """
        List used disks.

        :rtype: list[dict]
        """

    @abstractmethod
    def list_disks_unused(self):
        """
        List unused disks.

        :rtype: list[dict]
        """

    @abstractmethod
    def get_disk(self, id):  # pylint: disable=redefined-builtin
        """
        :type id: str
        :rtype: dict
        """

    @abstractmethod
    def list_pools(self):
        """

        :return:
        """

    @abstractmethod
    def list_pools_exported(self):
        """
        :return:
        """

    @abstractmethod
    def create_pool(self, data):
        """
        Creates pool
        """

    @abstractmethod
    def import_pool(self, data):
        """
        Imports pool
        """

    @abstractmethod
    def export_pool(self, data):
        """
        Exports pool
        """
