#!/usr/bin/python2
# -*- coding: utf-8 -*-

__author__ = 'Patryk Stachurski <patryk.stachurski@open-e.com>'
__revision__ = '$Id'

import sys

from jovianapi import API
from jovianapi.resource.pool import PoolModel


DEV_POOL_NAME_PREFIX = 'DevPool-'
DEV_DATASET_NAME_PREFIX = 'DevDataset-'
DEV_SHARE_NFS_NAME_PREFIX = 'DevShareNFS-'
DEV_SHARE_SMB_NAME_PREFIX = 'DevShareSMB-'

GiB = 1024**3


# Init API
api = API.via_rest()


# Script flow
# Find name for new pool
all_pools = [pool for pool in api.storage.pools if pool.name.startswith(DEV_POOL_NAME_PREFIX)]
all_pools.extend([pool for pool in api.storage.pools.exported if pool.name.startswith(DEV_POOL_NAME_PREFIX)])
all_pools_names = [pool.name for pool in all_pools]

pool_id = -1  # for pylint
for pool_id in xrange(256):
    pool_name = DEV_POOL_NAME_PREFIX + str(pool_id)

    if pool_name not in all_pools_names:
        break
else:
    sys.exit("ERROR: Unable to chose pool name")

print 'Found name for new pool - %s' % pool_name

# Find one unused disk for new pool
unused_disks = api.storage.disks.unused
unused_disks.sort(key=lambda disk: disk.name)
if not unused_disks:
    sys.exit("ERROR: Unable to create dev storage as there aren't any unused disks")

pool_disk = unused_disks[0]
vdev = PoolModel.VdevModel(type=PoolModel.VdevModel.TYPE_SINGLE, disks=[pool_disk])

print 'Found unused disk for new pool - %s' % pool_disk.name

# Create pool
pool = api.storage.pools.create(pool_name, vdevs=[vdev])
print 'Created new pool - %s' % pool_name

# Create dataset
dataset_name = DEV_DATASET_NAME_PREFIX + str(pool_id)
dataset = pool.datasets.create(dataset_name)
print 'Created new dataset - %s/%s' % (pool_name, dataset_name)

# Create NFS share
nfs_share_name = DEV_SHARE_NFS_NAME_PREFIX + str(pool_id)
nfs_share = dataset.shares.create(nfs_share_name, nfs_options=dict(enabled=True))
print 'Created new NFS share - %s/%s/%s' % (pool_name, dataset_name, nfs_share_name)

# Create SMB share
smb_share_name = DEV_SHARE_SMB_NAME_PREFIX + str(pool_id)
smb_share = dataset.shares.create(smb_share_name, smb_options=dict(enabled=True))
print 'Created new SMB share - %s/%s/%s' % (pool_name, dataset_name, smb_share_name)

# Create iSCSI target
target_no = len(pool.targets)
target_name = pool.name.lower() + ':target%d' % target_no
target = pool.targets.create(target_name)
print 'Created new iSCSI target - %s' % target_name

# Create Zvol
zvol_no = len(pool.volumes)
zvol_name = 'DevZvol%d' % zvol_no
zvol_size = 5*GiB
zvol = pool.volumes.create(zvol_name, zvol_size)
print 'Created new Zvol - %s' % zvol_name

# Attach Zvol to iSCSI target
target.attach_lun(zvol)
print 'Attached Zvol %s to iSCSI target %s' % (zvol.name, target.name)
