#!/usr/bin/python2
# -*- coding: utf-8 -*-

__author__ = 'Patryk Stachurski <patryk.stachurski@open-e.com>'
__revision__ = '$Id'

from jovianapi.resource.core import Resource
from jovianapi.resource.core import ResourcesContainer
from jovianapi.resource.core import UNDEFINED



class NodeModel(Resource):
    FIELDS_NAMES = ['localnode', 'status', 'hostname', 'reachable', 'address', 'id']

    def __init__(self, localnode=UNDEFINED, status=UNDEFINED, hostname=UNDEFINED, reachable=UNDEFINED,
                 address=UNDEFINED, id=UNDEFINED, api=None):  # pylint: disable=redefined-builtin
        """
        :type localnode: bool
        :type status: unicode
        :type hostname: unicode
        :type reachable: bool
        :type address: unicode
        :type id: unicode
        :type api: jovianapi.API
        """
        Resource.__init__(self, api=api)

        self.localnode = localnode
        self.status = status
        self.hostname = hostname
        self.reachable = reachable
        self.address = address
        self.id = id


class Node(NodeModel):
    pass


class NodesContainer(ResourcesContainer):
    def fetch(self):
        items = self.driver.list_cluster_nodes().data
        return [Node.from_dict(i, api=self.api) for i in items]

    def __getitem__(self, item):
        """
        :rtype: Node
        """
        return super(NodesContainer, self).__getitem__(item)
