#!/usr/bin/python2
# -*- coding: utf-8 -*-

__author__ = 'Patryk Stachurski <patryk.stachurski@open-e.com>'
__revision__ = '$Id'

from jovianapi.resource.core import Resource
from jovianapi.resource.core import ResourcesContainer
from jovianapi.resource.core import UNDEFINED


class DisksContainer(ResourcesContainer):
    def fetch(self):
        items = self.driver.list_disks().data
        return [Disk.from_dict(d) for d in items]

    @property
    def used(self):
        """
        :rtype: list[Disk]
        """
        self.refresh()
        return [item for item in self if item.used]

    @property
    def unused(self):
        """
        :rtype: list[Disk]
        """
        self.refresh()
        return [item for item in self if not item.used]


class Disk(Resource):
    """
    Example JSON::

        {
            "origin": "local",
            "pool_name": null,
            "used": true,
            "led": "off",
            "assignment": "system_disk",
            "spare": [],
            "path": null,
            "id": "scsi-SATA_ST3500630NS_9QG8WWA3",
            "size": 500107862016,
            "name": "sda",
            "sn": "9QG8WWA3",
            "model": "ST3500630NS     ",
            "type": "single"
        }
    """

    FIELDS_NAMES = ['origin', 'pool_name', 'used', 'led', 'name', 'assignment', 'spare', 'sn', 'path', 'model', 'type', 'id', 'size']

    def __init__(self, origin=UNDEFINED, pool_name=UNDEFINED, used=UNDEFINED, led=UNDEFINED, name=UNDEFINED,
                 assignment=UNDEFINED, spare=UNDEFINED, sn=UNDEFINED, path=UNDEFINED, model=UNDEFINED,
                 type=UNDEFINED, id=UNDEFINED, size=UNDEFINED, api=None):  # pylint: disable=redefined-builtin
        """
        :type origin: unicode
        :type pool_name: NoneType
        :type used: bool
        :type led: unicode
        :type name: unicode
        :type assignment: unicode
        :type spare: list
        :type sn: unicode
        :type path: NoneType
        :type model: unicode
        :type type: unicode
        :type id: unicode
        :type size: int
        :type api: jovianapi.API
        """
        Resource.__init__(self, api=api)

        self.origin = origin
        self.pool_name = pool_name
        self.used = used
        self.led = led
        self.name = name
        self.assignment = assignment
        self.spare = spare
        self.sn = sn
        self.path = path
        self.model = model
        self.type = type
        self.id = id
        self.size = size
