#!/usr/bin/python2
# -*- coding: utf-8 -*-

__author__ = 'Patryk Stachurski <patryk.stachurski@open-e.com>'
__revision__ = '$Id'

from jovianapi.menu.core import BaseMenu

from jovianapi.resource.node import NodesContainer
from jovianapi.resource.zfs_resource import ZfsResourcesContainer


class ClusterMenu(BaseMenu):
    """Menu containing cluster resources.
    """

    def __init__(self, api):
        super(ClusterMenu, self).__init__(api)

    @property
    def nodes(self):
        """
        :rtype: :class:`jovianapi.resource.node.NodesContainer`
        """
        return NodesContainer(self.api)

    @property
    def zfs_resources(self):
        return ZfsResourcesContainer(self.api)



