#!/usr/bin/python2
# -*- coding: utf-8 -*-

__author__ = 'Patryk Stachurski <patryk.stachurski@open-e.com>'
__revision__ = '$Id'

from jovianapi.resource.core import Resource
from jovianapi.resource.core import ResourcesContainer
from jovianapi.resource.core import UNDEFINED


class TargetModel(Resource):
    class OutgoingUserModel(Resource):
        FIELDS_NAMES = ['name']

        def __init__(self, name=UNDEFINED, api=None):
            """
            :type name: unicode
            :type api: jovianapi.API
            """
            Resource.__init__(self, api=api)

            self.name = name

    FIELDS_NAMES = ['incoming_users_active', 'name', 'allow_ip', 'outgoing_user', 'active', 'conflicted', 'deny_ip']

    def __init__(self, incoming_users_active=UNDEFINED, name=UNDEFINED, allow_ip=UNDEFINED, outgoing_user=UNDEFINED,
                 active=UNDEFINED, conflicted=UNDEFINED, deny_ip=UNDEFINED, pool=None, api=None):
        """
        :type incoming_users_active: bool
        :type name: unicode
        :type allow_ip: list[unicode]
        :type outgoing_user: OutgoingUserModel
        :type active: bool
        :type conflicted: bool
        :type deny_ip: list[unicode]
        :type pool: jovianapi.resource.pool.Pool
        :type api: jovianapi.API
        """
        Resource.__init__(self, api=api)

        self.incoming_users_active = incoming_users_active
        self.name = name
        self.allow_ip = allow_ip
        self.outgoing_user = self.OutgoingUserModel.from_dict(outgoing_user if outgoing_user is not None else UNDEFINED)
        self.active = active
        self.conflicted = conflicted
        self.deny_ip = deny_ip

        self.pool = pool


class Target(TargetModel):
    def attach_lun(self, volume):
        from jovianapi.resource.volume import VolumeModel

        if isinstance(volume, VolumeModel):
            volume_name = volume.name
        else:
            volume_name = str(volume)

        lun_data = dict(name=volume_name)

        self.driver.attach_lun_to_target(self.pool.name, self.name, lun_data)


class TargetsContainer(ResourcesContainer):
    def __init__(self, pool):
        """
        :type pool: jovianapi.resource.pool.Pool
        """
        self.pool = pool

        super(TargetsContainer, self).__init__(pool.api)

    def fetch(self):
        items = self.driver.list_targets(self.pool.name).data
        return [Target.from_dict(d, api=self.api, pool=self.pool) for d in items]

    def create(self, name):
        target_model = TargetModel(name=name)
        target_data = target_model.to_dict()

        self.driver.create_target(self.pool.name, target_data)
        self.refresh()
        for target in self:
            if target.name == name:
                return target
