#!/usr/bin/python2
# -*- coding: utf-8 -*-

__author__ = 'Patryk Stachurski <patryk.stachurski@open-e.com>'
__revision__ = '$Id'

from jovianapi.menu.core import BaseMenu

from jovianapi.resource.disk import DisksContainer
from jovianapi.resource.pool import PoolsContainer


class StorageMenu(BaseMenu):
    """Menu containing storage resources.

    Elements of menu are:
     - Pools (:class:`jovianapi.resource.pool.PoolsContainer`)
     - Disks (:class:`jovianapi.resource.disk.DisksContainer`)
    """

    def __init__(self, api):
        super(StorageMenu, self).__init__(api)

    @property
    def pools(self):
        """
        :rtype: :class:`jovianapi.resource.pool.PoolsContainer`
        """
        return PoolsContainer(self.api)

    @property
    def disks(self):
        """
        :rtype: :class:`jovianapi.resource.disk.DisksContainer`
        """
        return DisksContainer(self.api)


