#!/usr/bin/python2
# -*- coding: utf-8 -*-

__author__ = 'Patryk Stachurski <patryk.stachurski@open-e.com>'
__revision__ = '$Id'

from jovianapi.resource.core import Resource
from jovianapi.resource.core import ResourcesContainer
from jovianapi.resource.core import UNDEFINED


class DatasetModel(Resource):
    FIELDS_NAMES = ['origin', 'compression', 'primarycache', 'refquota', 'logbias', 'dedup', 'quota', 'copies', 'sync',
                    'refreservation', 'full_name', 'reservation', 'atime', 'secondarycache', 'name']

    def __init__(self, origin=UNDEFINED, compression=UNDEFINED, primarycache=UNDEFINED, refquota=UNDEFINED,
                 logbias=UNDEFINED, dedup=UNDEFINED, quota=UNDEFINED, copies=UNDEFINED, sync=UNDEFINED,
                 refreservation=UNDEFINED, full_name=UNDEFINED, reservation=UNDEFINED, atime=UNDEFINED,
                 secondarycache=UNDEFINED, name=UNDEFINED, pool=None, api=None):
        """
        :type origin: NoneType
        :type compression: unicode
        :type primarycache: unicode
        :type refquota: NoneType
        :type logbias: unicode
        :type dedup: unicode
        :type quota: NoneType
        :type copies: unicode
        :type sync: unicode
        :type refreservation: NoneType
        :type full_name: unicode
        :type reservation: NoneType
        :type atime: unicode
        :type secondarycache: unicode
        :type name: unicode
        :type pool: jovianapi.resource.pool.Pool
        :type api: jovianapi.API
        """
        Resource.__init__(self, api=api)

        self.origin = origin
        self.compression = compression
        self.primarycache = primarycache
        self.refquota = refquota
        self.logbias = logbias
        self.dedup = dedup
        self.quota = quota
        self.copies = copies
        self.sync = sync
        self.refreservation = refreservation
        self.full_name = full_name
        self.reservation = reservation
        self.atime = atime
        self.secondarycache = secondarycache
        self.name = name

        self.pool = pool


class Dataset(DatasetModel):
    @property
    def shares(self):
        """
        :rtype: jovianapi.resource.share.SharesContainer
        """
        from jovianapi.resource.share import SharesContainer
        return SharesContainer(self)


class DatasetsContainer(ResourcesContainer):
    def __init__(self, pool):
        """
        :type pool: jovianapi.resource.pool.Pool
        """
        self.pool = pool

        super(DatasetsContainer, self).__init__(pool.api)

    def fetch(self):
        items = self.driver.list_datasets(self.pool.name).data
        return [Dataset.from_dict(d, api=self.api, pool=self.pool) for d in items]

    def create(self, name):
        data = dict(name=name)
        self.driver.create_dataset(self.pool.name, data)
        return self[name]

        # just for code hint
    def __getitem__(self, name):
        """
        :rtype: Dataset
        """
        return super(DatasetsContainer, self).__getitem__(name)




